<%@page contentType="text/html;charset=utf-8"%>
<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml" lang="ko" xml:lang="ko">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta http-equiv="Content-Script-Type" content="text/javascript" />
<meta http-equiv="Content-Style-Type" content="text/css" />
<meta http-equiv="X-UA-Compatible" content="IE=edge" />
<title>IBChart Sample</title>
</head>

		<script type="text/javascript" src="../js/common.js"></script>
		<script type="text/javascript" src="../Chart/highcharts/highcharts.js"></script>
		<script type="text/javascript" src="../Chart/ibchart.js"></script>
		<script type="text/javascript" src="../Chart/ibchartinfo.js"></script>


<script type="text/javascript">
	var pageheightoffset = 250;
	function PageLoad() {
		createIBChart("myChart", "myChart", {
			width: "100%",
			height: "100%"
		});
		ChartDesign();
		fnChartColumnType();
	}

	function ChartDesign() {
		myChart.setOptions({
			chart:{
				type:"column",
				plotBackgroundColor : "#F7FAFB",
				plotBorderColor : "#A9AEB1",
				plotBorderWidth:0.5,
				backgroundColor:{
					linearGradient : [0,0,100,500],
					stops : [
						[0, "#FFFFFF"],
						[1, "#D3D9E5"]
					]
				},
				borderColor : "#84888B",
				animation:true
			},
			colors: ["#66ccff", "#F7819F", "#89A54E", "#80699B", "#3D96AE", "#DB843D", "#92A8CD", "#A47D7C", "#B5CA92", "#F7819F"],
			plotOptions:{
				"series":{
					"dataLabels":{ //데이터 레이블을 데이터 가운데 표시
						"enabled":true
					}
				}
			},
			title:{
				enabled : true,
				text:"팀별 매출 현황",
				style:{
					fontWeight:"bold",
					color:"#15498B"
				}
			},
			yAxis:[{
				title:{
					enabled: false
				},
				plotLines: [{    //기준선
				    color: 'blue',
				    dashStyle: 'dash',
				    value: 250,
				    width: 2
				  }]
			},{
				opposite:1,
				title:{
					enabled:false
				}
			}],
			xAxis:{
				gridLineWidth:0.5,
				gridLineColor:"#C4C9CD",
				gridLineDashStyle:"solid",
				linecolor:"#9BA3A5",
				minorTickColor:"#7C7C7E",
				tickColor:"#7C7C7E",
				labels:{
					enabled:true,
					rotation:20,
					y:20
				},
				tickInterval:1,
				plotBands: [   //특정 구간 설정
				{
				    color: '#FFDDDD',
				    from: 1, //시작점
				    to: 2,  //끝점
				    label: {  //구간 내용
					    text: '구간 1',
					    align: 'center',
					    verticalAlign:'top'
					 }//end label
				  },
					{
				    color: '#DDDDFF',
				    from: 3,
				    to: 5.5,
				    label: {
					    text: '구간 2',
					    align: 'center',
					    verticalAlign:'top'
					 }//end label
				  }],
				 plotLines: [{  //기준선
				    color: 'red',
				    dashStyle: 'solid',
				    value: 7.3,
				    width: 2
				  }]
			},
			legend:{
				enabled:true,
				layout:"vertical",
				align:"right",
				verticalAlign:"middle"
			},
			tooltip:{
				enabled:true,
				formatter:function(){
					return '<span style="color: #4572A7">' + this.series.name + '</span><br/>' + this.point.name + ' : ' + this.y ;
				}
			},
			events: {
				searchEnd: myChart_OnSearchEnd
			}
		});
	}

	function fnChartColumnType(Type)
	{
		// myChart.removeAll();

		// ajax로 json 데이타가져오기
		DoSearch(myChart,"chart02_data.jsp");
	}


	function DoSearch(chart,url,subparam){
		$.ajax({
      		type: 'post'
			, async: true
			, dataType:"text"
			, url: url
			, data:  subparam
			, beforeSend: function() {

			  }
			, success: function(xml) {
				chart.loadSearchData(xml, {
					append: true
				});
			  }
			, error: function(data, status, err) {
			    alert('서버와의 통신이 실패했습니다.');
			  }
			  ,complete:function(jqXHR,textStatus){

			  }
		});
	}

	function myChart_OnSearchEnd(code,msg){
		//세번째,네번째 시리즈를 라인 차트로 변경하고 Y2축(오른쪽 Y축)에 할당 한다.
		myChart.series(0).setOptions({
			zIndex:1
		}, {
			append: true
		});
		myChart.series(1).setOptions({
			zIndex:1
		}, {
			append: true
		});
		myChart.series(2).setOptions({
			type : "line",
			zIndex:2,
			yAxis:1
		}, {
			append: true
		});
		myChart.series(3).setOptions({
			type : "line",
			zIndex:2,
			yAxis:1
		}, {
			append: true,
			redraw: true
		});
	}
</script>

<body onload="PageLoad()">
	<div class="page_title">
		<span><a class="closeDepth" href="#">closeDepth</a></span>
		<span class="title color_sheet">차트 조회 > <b>json 조회</b></span>
	</div>
	<div class="main_content">
		<div class="exp_product">
			차트 조회의 데이타구조를 JSON으로 생성합니다.
		</div>

		<div class="ib_function float_right">
		</div>

		<div class="clear hidden"></div>

		<!--div class="ib_function2 border_chart"></div>-->

		<p class="subtit_chart">차트 조회</p>
		<div class="ib_product">
			<div id="myChart"></div>
		</div>
	</div>
</body>
</html>
